%define major 18
%define libname %mklibname %{name}-glib %{major}
%define girmajor 1.0
%define girname_glib %mklibname %{name}glib-gir %{girmajor}

%define develname %mklibname -d %{name}

# Required due to libhif patch things
%define hifsomajor 1
%define min_hif_ver 0.2.3
%define min_hif_verrel %{min_hif_ver}-1

Summary:	A DBUS packaging abstraction layer
Name:	  	packagekit
Version:	1.1.3
Release:	%mkrel 2
License:	GPLv2+
Group:		System/Packaging
URL:		http://www.packagekit.org
Source0: 	https://www.freedesktop.org/software/PackageKit/releases/PackageKit-%{version}.tar.xz

# Patches backported from upstream
Patch0:		0001-Annotate-PreparedUpgrade-DBus-property-for-usage-in-.patch
Patch1:		0002-Fix-two-small-memory-leaks-when-processing-signals-f.patch

BuildRequires:	pkgconfig(cairo)
BuildRequires:	pkgconfig(fontconfig)
BuildRequires:	pkgconfig(gio-2.0) >= 2.16.1
BuildRequires:	pkgconfig(gio-unix-2.0)
BuildRequires:	pkgconfig(gio-unix-2.0) >= 2.16.1
BuildRequires:	pkgconfig(glib-2.0) >= 2.32.0
BuildRequires:	pkgconfig(gmodule-2.0)
BuildRequires:	pkgconfig(gobject-2.0)
BuildRequires:	pkgconfig(gstreamer-1.0)
BuildRequires:	pkgconfig(gstreamer-base-1.0)
BuildRequires:	pkgconfig(gstreamer-plugins-base-1.0)
BuildRequires:	pkgconfig(gtk+-2.0) >= 2.14.0
BuildRequires:	pkgconfig(gtk+-3.0) >= 3.0.0
BuildRequires:	pkgconfig(gudev-1.0)
BuildRequires:	pkgconfig(libsystemd) >= 216
BuildRequires:	pkgconfig(NetworkManager) >= 0.6.4
BuildRequires:	pkgconfig(nspr) >= 4.8
BuildRequires:	pkgconfig(pango)
BuildRequires:	pkgconfig(pangoft2)
BuildRequires:	pkgconfig(pm-utils)
BuildRequires:	pkgconfig(polkit-gobject-1) >= 0.98
BuildRequires:	pkgconfig(sqlite3)
BuildRequires:	pkgconfig(xt)
BuildRequires:	pkgconfig(appstream-glib)
BuildRequires:	pkgconfig(libhif) >= %{min_hif_ver}
BuildRequires:	pkgconfig(vapigen)
BuildRequires:	libhif-devel >= %{min_hif_verrel}
BuildRequires:	python3-devel
BuildRequires:	intltool
BuildRequires:	gtk-doc
BuildRequires:	gobject-introspection
BuildRequires:	pkgconfig(gobject-introspection-1.0)
BuildRequires:	bash-completion
Requires:       %{mklibname hif %{hifsomajor}} >= %{min_hif_verrel}
Recommends:	%{name}-gtk-module = %{version}
Recommends:	packagekit-gui
Obsoletes:	%{name}-smart < 1.0.0
Obsoletes:	%{name}-browser-plugin < 1.1.0
Requires(post):	rpm-helper
Requires(preun): rpm-helper

%description
PackageKit is a DBUS abstraction layer that allows the session user to manage
packages in a secure way using a cross-distro, cross-architecture API.

%package -n %{libname}
Summary: Libraries for accessing PackageKit
Group: System/Packaging

%description -n %{libname}
Libraries for accessing PackageKit.

%package -n %{girname_glib}
Summary: GObject Introspection interface description for PackageKit
Group: System/Packaging
Requires: %{libname} = %{version}-%{release}
Conflicts: %{_lib}packagekit-glib14 < 0.6.17-2
Obsoletes: %{_lib}packagekitplugin-gir1.0 < 1.0.0

%description -n %{girname_glib}
GObject Introspection interface description for PackageKit.

%package -n %{develname}
Summary: Libraries and headers for PackageKit
Group: Development/Other
Requires: %{libname} = %{version}-%{release}
Requires: %{girname_glib} = %{version}-%{release}
Provides: %{name}-devel = %{version}-%{release}
Conflicts: %{_lib}packagekit-glib14 < 0.6.17-2

%description -n %{develname}
Headers and libraries for PackageKit.

%package cron
Summary: Cron job and related utilities for PackageKit
Group: System/Packaging
Requires: crontabs
Requires: %{name} = %{version}-%{release}

%description cron
Crontab and utilities for running PackageKit as a cron job.

%package gstreamer-plugin
Summary: Install GStreamer codecs using PackageKit
Group: System/Packaging
Requires: gstreamer1.0-tools
Requires(post): update-alternatives
Requires(postun): update-alternatives
Provides: gst-install-plugins-helper
Requires: %{name} = %{version}-%{release}

%description gstreamer-plugin
The PackageKit GStreamer plugin allows any Gstreamer application to install
codecs from configured repositories using PackageKit.

%package command-not-found
Summary: Ask the user to install command line programs automatically
Group: System/Packaging
Requires: %{name} = %{version}-%{release}

%description command-not-found
A simple helper that offers to install new packages on the command line
using PackageKit.

%package gtk-module
Summary: Install fonts automatically using PackageKit
Group: System/Packaging
Requires: pango
Requires: %{name} = %{version}-%{release}

%description gtk-module
The PackageKit GTK+ module allows any Pango application to install
fonts from configured repositories using PackageKit.

%package gtk3-module
Summary: Install fonts automatically using PackageKit
Group: System/Packaging
Requires: pango
Requires: %{name} = %{version}-%{release}

%description gtk3-module
The PackageKit GTK3+ module allows any Pango application to install
fonts from configured repositories using PackageKit.

%prep
%setup -q -n PackageKit-%{version}
%autopatch -p1

%build

# We do not install in /usr/libexec
sed -e 's,/usr/libexec,%{_libexecdir},g' -i contrib/command-not-found/PackageKit.sh.in
sed -e 's,/usr/libexec,%{_libexecdir},g' -i contrib/command-not-found/PackageKit.sh

%configure2_5x \
	--disable-static \
	--enable-gstreamer-plugin \
	--enable-systemd \
	--disable-alpm \
	--disable-apt \
	--enable-dummy \
	--disable-pisi \
	--disable-poldek \
	--disable-urpmi \
	--disable-zypp \
	--enable-hif \
	--with-hif-vendor=mageia \
	--enable-python3 \
	--enable-vala \
	--enable-introspection

find -name '*.moc' -exec rm -f {} \;
%make_build V=1

%install
%make_install

find %{buildroot} -name *.la | xargs rm

%{find_lang} PackageKit

%post
# the job count used to live in /var/run, but it's now in /var/lib with the
# other persistent bits
if [ -e %{_localstatedir}/run/PackageKit/job_count.dat ]; then
	mv %{_localstatedir}/run/PackageKit/job_count.dat %{_localstatedir}/lib/PackageKit/job_count.dat
fi
%_post_service packagekit

%files -f PackageKit.lang
%dir %{_sysconfdir}/PackageKit
%config(noreplace) %{_sysconfdir}/PackageKit/PackageKit.conf
%config(noreplace) %{_sysconfdir}/PackageKit/Vendor.conf
%config(noreplace) %{_sysconfdir}/PackageKit/CommandNotFound.conf
#%{_sysconfdir}/PackageKit/events/post-transaction.d/README
#%{_sysconfdir}/PackageKit/events/pre-transaction.d/README
%{_sysconfdir}/dbus-1/system.d/*.conf
%{_unitdir}/packagekit.service
%{_unitdir}/packagekit-offline-update.service
%dir %{_unitdir}/system-update.target.wants
%{_unitdir}/system-update.target.wants/packagekit-offline-update.service
%{_bindir}/*
%{_datadir}/PackageKit
%{_datadir}/polkit-1/actions/*.policy
%{_datadir}/bash-completion/completions/pkcon
%{_datadir}/dbus-1/system-services/*.service
%{_datadir}/dbus-1/interfaces/*.xml
%{_datadir}/polkit-1/rules.d/org.freedesktop.packagekit.rules
%{_datadir}/gtk-doc/html/PackageKit
%{_libexecdir}/packagekitd
%{_libexecdir}/packagekit-direct
%{_libexecdir}/pk-offline-update
%dir %{_libdir}/packagekit-backend
%{_libdir}/packagekit-backend/libpk_backend_dummy.so
%{_libdir}/packagekit-backend/libpk_backend_test_fail.so
%{_libdir}/packagekit-backend/libpk_backend_test_nop.so
%{_libdir}/packagekit-backend/libpk_backend_test_spawn.so
%{_libdir}/packagekit-backend/libpk_backend_test_succeed.so
%{_libdir}/packagekit-backend/libpk_backend_test_thread.so
%{_libdir}/packagekit-backend/libpk_backend_hif.so
%{_mandir}/man1/*
%ghost %verify(not md5 size mtime) %{_var}/lib/PackageKit/transactions.db

%files -n %{libname}
%{_libdir}/*packagekit-glib*.so.%{major}{,.*}

%files -n %{girname_glib}
%{_libdir}/girepository-1.0/PackageKitGlib-%{girmajor}.typelib

%files -n %{develname}
%{_includedir}/PackageKit
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_datadir}/gir-1.0/PackageKitGlib-%{girmajor}.gir
%{_datadir}/vala/vapi/packagekit-glib2.vapi

%files cron
%config %{_sysconfdir}/cron.daily/*.cron
%config %{_sysconfdir}/sysconfig/packagekit-background

%files gstreamer-plugin
%{_libexecdir}/pk-gstreamer-install

%post gstreamer-plugin
update-alternatives --install %{_libexecdir}/gst-install-plugins-helper gst-install-plugins-helper %{_libexecdir}/pk-gstreamer-install 10

%postun gstreamer-plugin
if [ "$1" = "0" ]; then
    if ! [ -e %{_libexecdir}/pk-gstreamer-install ]; then
        update-alternatives --remove gst-install-plugins-helper %{_libexecdir}/pk-gstreamer-install
    fi
fi

%files command-not-found
%{_sysconfdir}/profile.d/*
%{_libexecdir}/pk-command-not-found

%files gtk-module
%{_libdir}/gtk-2.0/modules/*.so

%files gtk3-module
%{_libdir}/gtk-3.0/modules/*.so
%{_libdir}/gnome-settings-daemon-3.0/gtk-modules/pk-gtk-module.desktop



%changelog
* Fri Jul 22 2016 ngompa <ngompa> 1.1.3-2.mga6
+ Revision: 1043107
- Backport patches to fix PackageKitQt and fix memory leaks

* Sun Jul 17 2016 ngompa <ngompa> 1.1.3-1.mga6
+ Revision: 1042323
- Upgrade to 1.1.3

* Tue Jul 12 2016 ngompa <ngompa> 1.1.2-1.mga6
+ Revision: 1041275
- Upgrade to 1.1.2, drop upstreamed patches

* Sun Jun 26 2016 ngompa <ngompa> 1.1.1-6.mga6
+ Revision: 1037688
- Update patch for setting officially supported sources

* Mon Jun 13 2016 ngompa <ngompa> 1.1.1-5.mga6
+ Revision: 1021289
- Add proper constraints to ensure matching libhif versions are installed
- Backport patches from upstream

* Wed Jun 08 2016 tv <tv> 1.1.1-4.mga6
+ Revision: 1020783
- adjust BRs for latest systemd

* Sat May 28 2016 ngompa <ngompa> 1.1.1-3.mga6
+ Revision: 1019190
- Disable PackageKit-Urpmi backend

* Fri May 27 2016 ngompa <ngompa> 1.1.1-2.mga6
+ Revision: 1018859
- Revert to using /etc/yum.repos.d

* Fri Apr 29 2016 ngompa <ngompa> 1.1.1-1.mga6
+ Revision: 1007649
- Upgrade to 1.1.1

* Tue Mar 15 2016 ngompa <ngompa> 1.1.0-1.mga6
+ Revision: 990959
- Update to 1.1.0
- Add patches to use /etc/distro.repos.d and set mageia repos as supported

* Sun Jan 03 2016 luigiwalser <luigiwalser> 1.0.11-1.mga6
+ Revision: 918826
- 1.0.11

* Sat Oct 10 2015 ovitters <ovitters> 1.0.10-2.mga6
+ Revision: 888709
- enable hif backend
- enable vala
- enable python3

* Fri Oct 09 2015 ovitters <ovitters> 1.0.10-1.mga6
+ Revision: 888012
- new version 1.0.10

* Thu Sep 24 2015 tv <tv> 1.0.9-1.mga6
+ Revision: 883344
- drop merged patch
- new release

* Wed Jun 10 2015 tv <tv> 1.0.6-0.4.1.mga5
+ Revision: 822971
- new release
- add proper systemd support
- fix is_package_installed()
- new release
- add proper systemd support
- fix is_package_installed()

  + ovitters <ovitters>
    - new version 1.0.5
    - hopefully fix the linking error

* Wed Nov 19 2014 tv <tv> 1.0.3-2.mga5
+ Revision: 797905
- more fixes

* Tue Nov 18 2014 tv <tv> 1.0.3-1.mga5
+ Revision: 797762
- new release
- re-enable backend
- implement a couple features

* Wed Oct 15 2014 umeabot <umeabot> 1.0.0-2.mga5
+ Revision: 748790
- Second Mageia 5 Mass Rebuild

* Tue Sep 30 2014 wally <wally> 1.0.0-1.mga5
+ Revision: 732468
- drop smart backend and plugins gir pkg
- rebuild with new rpm-mageia-setup to generate requires for .typelib files

  + fwang <fwang>
    - enable systemd support
    - drop old switches

  + tv <tv>
    - rebuild for missing pythoneggs deps
    - s/uggests:/Recommends:/

  + umeabot <umeabot>
    - Mageia 5 Mass Rebuild

  + ovitters <ovitters>
    - new version 1.0.0

* Tue Sep 09 2014 luigiwalser <luigiwalser> 0.9.5-1.mga5
+ Revision: 674261
- 0.9.5

* Wed Sep 03 2014 joequant <joequant> 0.9.4-2.mga5
+ Revision: 671650
- update to new systemd libraries

* Thu Aug 07 2014 fwang <fwang> 0.9.4-1.mga5
+ Revision: 660770
- bump libmajor
- update file list
- 0.9.4

  + pterjan <pterjan>
    - Rebuild for new Python

* Mon Feb 10 2014 luigiwalser <luigiwalser> 0.8.14-4.mga5
+ Revision: 589152
- add patch from debian to stop packagekit from spamming syslog (mga#12568)

* Sat Jan 11 2014 dmorgan <dmorgan> 0.8.14-3.mga4
+ Revision: 566230
- Fix BuildRequires

* Mon Jan 06 2014 pterjan <pterjan> 0.8.14-2.mga4
+ Revision: 564989
- Add missing annotation in DBUS interface to fix packagekit-qt build

* Thu Dec 12 2013 tv <tv> 0.8.14-1.mga4
+ Revision: 556452
- new release
- enable backend

* Sat Oct 19 2013 umeabot <umeabot> 0.8.10-3.mga4
+ Revision: 530882
- Mageia 4 Mass Rebuild

* Tue Jul 30 2013 fwang <fwang> 0.8.10-2.mga4
+ Revision: 460838
- cleanup spec
- update file list

  + tv <tv>
    - new release

* Fri May 24 2013 tv <tv> 0.8.9-1.mga4
+ Revision: 426534
- adjust file list
- adjust file list
- BR bash-completion
- new release

* Thu Feb 14 2013 fwang <fwang> 0.8.6-7.mga3
+ Revision: 398367
- recognize gstreamer1

* Tue Jan 22 2013 fwang <fwang> 0.8.6-6.mga3
+ Revision: 390697
- update rpm group
- update rpm group

* Sun Jan 13 2013 umeabot <umeabot> 0.8.6-5.mga3
+ Revision: 362339
- Mass Rebuild - https://wiki.mageia.org/en/Feature:Mageia3MassRebuild

* Thu Dec 06 2012 fwang <fwang> 0.8.6-4.mga3
+ Revision: 327147
- update rpm group

  + tv <tv>
    - enable smart backend (mga#7109)

* Mon Dec 03 2012 tv <tv> 0.8.6-3.mga3
+ Revision: 325721
- patch 5: actually enable backend

* Sat Dec 01 2012 tv <tv> 0.8.6-2.mga3
+ Revision: 323915
- patch 4: important urpmi fixes from git

* Sat Dec 01 2012 fwang <fwang> 0.8.6-1.mga3
+ Revision: 323683
- update file list
- update file list
- update file list
- update file list
- update brs
- new version 0.8.6 for better support on urpmi

* Thu Jul 19 2012 ovitters <ovitters> 0.7.5-1.mga3
+ Revision: 272636
- add subpackage for packagekitplugin gir
- update file list even more
- update file list
- update file list
- qtlib subpackage has been removed upstream (qtlib2 exists)
- explicitly enable qt plugin
- add upstream patch to fix build
- new version 0.7.5 (less api breaks)
- new version 0.8.1
- verbose build
- clean spec
- drop upstreamed patch 5
- rediff patches
- new version 0.7.4

* Sun Mar 11 2012 fwang <fwang> 0.6.21-3.mga2
+ Revision: 222573
- br xt
- add mandriva patch on providing what-provides feature

* Wed Jan 04 2012 fwang <fwang> 0.6.21-2.mga2
+ Revision: 190642
- rebuild for new libarchive

* Mon Dec 26 2011 fwang <fwang> 0.6.21-1.mga2
+ Revision: 187745
- new version 0.6.21
- new version 0.6.20

* Sun Nov 06 2011 fwang <fwang> 0.6.19-1.mga2
+ Revision: 164386
- new version 0.6.19

* Mon Sep 26 2011 fwang <fwang> 0.6.18-2.mga2
+ Revision: 148781
- update file list
- revert to 0.6.18, urpmi backend is not maintained now
- new version 0.7.0
  only build urpmi backend, as we dont have smrt now

* Fri Sep 16 2011 ovitters <ovitters> 0.6.18-1.mga2
+ Revision: 144334
- add patch
- make it build with qt 4.7 and newest glib
- new version 0.6.18 (doesn't build yet, dmorgan would help fix it)

  + fwang <fwang>
    - gir should require libs
    - split gir files
    - new verrsion 0.6.17
    - update qtlib2 package name

  + stormi <stormi>
    - increase default max search time for packagekit-command-not-found (fixes mga bug #2183)

* Mon Jul 18 2011 dmorgan <dmorgan> 0.6.16-4.mga2
+ Revision: 125620
- Disable time estimation

* Sun Jul 17 2011 dmorgan <dmorgan> 0.6.16-3.mga2
+ Revision: 125518
- Enable suggests on packagekit-gtk-module now that we have font provides
  add more requires

* Sun Jul 17 2011 dmorgan <dmorgan> 0.6.16-2.mga2
+ Revision: 125512
- Fix path to packagekitd

* Tue Jul 05 2011 fwang <fwang> 0.6.16-1.mga2
+ Revision: 118700
- new version 0.6.16

* Wed Jun 15 2011 dmorgan <dmorgan> 0.6.15-2.mga2
+ Revision: 106389
- Create gtk3-module subpackage

* Wed Jun 15 2011 dmorgan <dmorgan> 0.6.15-1.mga2
+ Revision: 106384
- Add gtk3 as buildrequire
- New version 0.6.15

* Sun May 15 2011 pterjan <pterjan> 0.6.13-3.mga1
+ Revision: 98937
- Rebuild for fixed find-requires

* Wed Apr 13 2011 mikala <mikala> 0.6.13-2.mga1
+ Revision: 84617
- Add patch100 to fix a crash when browsing groups in kpackagekit

* Wed Apr 13 2011 mikala <mikala> 0.6.13-1.mga1
+ Revision: 84549
- Update tarball to 0.6.13
- Update patch1 :
  Remove the url regarding mandriva wiki
  Use mageia icon
- Add patch2 for urpmi backend:
  Disable backend_get_distro_upgrades for the moment
  Use mageia bugzilla for http
  Use mageia occurence instead of mandriva

* Sun Feb 20 2011 eandry <eandry> 0.6.11-2.mga1
+ Revision: 54927
- fix vendor patch (still needs a valid mageia wiki url)
- drop buildroot
- imported package packagekit

